/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.creeperhost.chickens.entity.EntityChickensChicken;
import net.creeperhost.chickens.entity.EntityColoredEgg;
import net.creeperhost.chickens.handler.SpawnType;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registry.f_122903_, (String)"chickens");
    public static final RegistryObject<EntityType<EntityColoredEgg>> EGG = ENTITIES.register("egg", () -> EntityType.Builder.m_20704_(EntityColoredEgg::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_("egg"));
    public static final List<EntityType<?>> SPAWNABLE_CHICKENS = new ArrayList();

    public static void init() {
        for (ChickensRegistryItem item : ChickensRegistry.getItems()) {
            EntityType entityType = EntityType.Builder.m_20704_(EntityChickensChicken::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(8).m_20712_(item.getEntityName());
            ENTITIES.register(item.getEntityName(), () -> entityType);
            if (!item.canSpawn()) continue;
            SPAWNABLE_CHICKENS.add(entityType);
            SpawnPlacements.m_21754_((EntityType)entityType, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (p_21781_, p_21782_, p_21783_, p_21784_, p_21785_) -> ModEntities.checkAnimalSpawnRules((EntityType<? extends Animal>)p_21781_, (LevelAccessor)p_21782_, p_21783_, p_21784_, p_21785_, item));
        }
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, Random random, ChickensRegistryItem chickensRegistryItem) {
        if (!levelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_184228_)) {
            return false;
        }
        if (!ModEntities.isBrightEnoughToSpawn((BlockAndTintGetter)levelAccessor, blockPos)) {
            return false;
        }
        if (!chickensRegistryItem.canSpawn()) {
            return false;
        }
        if (chickensRegistryItem.getSpawnType() == SpawnType.NORMAL) {
            return levelAccessor.m_6042_().m_63956_();
        }
        if (chickensRegistryItem.getSpawnType() == SpawnType.HELL) {
            return levelAccessor.m_6042_().m_63960_();
        }
        return true;
    }

    public static boolean isBrightEnoughToSpawn(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos) {
        return blockAndTintGetter.m_45524_(blockPos, 0) > 8;
    }
}

